package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.AdsMediaAppEntranceIncomeResponse;
import com.bxm.doris.facade.model.AdsMediaProfitByDataResponse;
import com.bxm.doris.facade.model.AnalysisMediaFlowRequest;
import com.bxm.doris.facade.model.AnalysisMediaFlowResponse;
import com.bxm.doris.facade.model.request.ProfitRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author tangxiao
 * @date 2023/12/13
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface AdsMediaFacadeService {

    /**
     * 广告位按日统计数据
     * @param appKey
     * @param startTime
     * @param endTime
     * @return
     */
    @PostMapping("/getAppEntranceRptByDate")
    List<AdsMediaAppEntranceIncomeResponse> getAppEntranceRptByDate(@RequestParam("appKey") String appKey, @RequestParam("startTime") String startTime,
                                                                    @RequestParam("endTime") String endTime);

    /**
     * 开发者分日数据
     * @param appKey
     * @param startTime
     * @param endTime
     * @return
     */
    @PostMapping("/getProviderDataByDate")
    List<AdsMediaProfitByDataResponse> getProviderDataByDate(@RequestParam("appKey") String appKey, @RequestParam("startTime") String startTime,
                                                             @RequestParam("endTime") String endTime);

    /**
     * 媒体分日数据
     * @param appKey
     * @param startTime
     * @param endTime
     * @param mediaId
     * @return
     */
    @PostMapping("/getMediaDataByDate")
    List<AdsMediaProfitByDataResponse> getMediaDataByDate(@RequestParam("appKey") String appKey, @RequestParam("startTime") String startTime,
                                                          @RequestParam("endTime") String endTime,
                                                          @RequestParam("mediaId") String mediaId);
    /**
     * 广告位分日数据
     * @param appKey
     * @param startTime
     * @param endTime
     * @param appEntranceId
     * @return
     */
    @PostMapping("/getPositionDataByDate")
    List<AdsMediaProfitByDataResponse> getPositionDataByDate(@RequestParam("appKey") String appKey, @RequestParam("startTime") String startTime,
                                                             @RequestParam("endTime") String endTime, @RequestParam("appEntranceId") String appEntranceId);



    /**
     * 广告位分日数据
     * @param appKey
     * @return
     */
    @PostMapping("/getProfitByAppKeyAndDate")
    BigDecimal profit(@RequestBody ProfitRequest profitRequest);




}
