package com.bxm.sync.facade.dto;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lowi
 * @date 2021/11/9 10:29
 */
@Data
@Builder
public class UserRewardDTO implements Serializable {

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 邀请用户
     */
    private Long inviteUserId;

    /**
     * 是否是临时邀请，如果是临时邀请关系，则以火啦临时邀请为主
     * 火啦临时不存在，则才以此邀请为主
     */
    private Boolean isTempInvite;

    /**
     * 是临时邀请，则有临时邀请时间
     */
    private Date tempInviteDate;
    /**
     * 注册奖励是否发放
     */
    private Boolean registerReward;

    /**
     * 微信奖励是否发放
     */
    private Boolean wxReward;
}
