package com.bxm.sync.facade.service;

import com.bxm.sync.facade.dto.ChickenGroupRegisterDTO;

/**
 * @author lowi
 * @date 2021/12/10 11:43
 */

public interface SixEnjoyChickenGroupFacadeService {

    /**
     * 加入群组
     *
     * @param userId  用户id
     * @param groupId 分组id
     * @return 是否成功
     */
    Boolean joinGroup(Long userId, Long groupId);

    /**
     * 退出群组
     *
     * @param userId  用户id
     * @param groupId 分组id
     * @return 是否成功
     */
    Boolean outGroup(Long userId, Long groupId);

    /**
     * 解散群组
     *
     * @param userId  用户id
     * @param groupId 分组id
     * @return 是否成功
     */
    Boolean clearGroup(Long userId, Long groupId);


    /**
     * 创建群组，获取六享那边的群组ID（六享库中是自增ID）
     *
     * @param userId 用户id
     * @return 是否成功
     */
    ChickenGroupRegisterDTO createGroup(Long userId);
}
