package com.bxm.sync.facade.service;

import com.bxm.sync.facade.dto.UserRewardDTO;
import com.bxm.sync.facade.param.UpdateUserInfoParam;
import com.bxm.sync.facade.param.UpdateUserRewardParam;

/**
 * @author lowi
 * @date 2021/11/9 10:26
 */

public interface SixEnjoyUserFacadeService {

    /**
     * 获取用户奖励信息
     *
     * @param userId 用户id
     * @return
     */
    UserRewardDTO getUserRewardInfo(Long userId, String phone, Long devcId);

    /**
     * 更新用户奖励信息
     *
     * @param updateUserRewardParam 更新参数
     * @return 是否成功
     */
    Boolean updateUserReward(UpdateUserRewardParam updateUserRewardParam);


    /**
     * 更新用户邀请信息
     *
     * @param userId       用户id
     * @param inviteUserId 邀请人id
     * @return 是否成功
     */
    Boolean updateUserInvite(Long userId, Long inviteUserId);

    /**
     * 更新用户信息
     *
     * @param updateUserInfoParam 更新用户信息
     * @return 是否成功
     */
    Boolean updateUserHeadImgOrNickname(UpdateUserInfoParam updateUserInfoParam);

}
