package com.bxm.sync.facade.service;

import java.util.List;

/**
 * @author lowi
 * @date 2021/9/27 20:58
 */

public interface SixEnjoyFriendsService {

    /**
     * 给6享增加好友关系
     *
     * @param userId       用户id
     * @param friendUserId 好友id
     */
    Boolean insertFriendsToSixEnjoy(Long userId, Long friendUserId);


    /**
     * 给6享删除好友关系
     *
     * @param userId       用户id
     * @param friendUserId 好友id
     */
    Boolean delFriendsToSixEnjoy(Long userId, Long friendUserId);

    /**
     * 是否是好友
     *
     * @param userId       用户id
     * @param friendUserId 好友id
     */
    Boolean isExistFriends(Long userId, Long friendUserId);

    /**
     * 获取好友用户id列表
     *
     * @param userId 用户id
     * @return 列表
     */
    List<Long> getFriendsIdByUserId(Long userId);
}
