package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.entry.AdvertEntry;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @ClassName ActivityAdvertMapper
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/1 13:51
 * @Version 1.0.0
 **/
@Mapper
public interface ActivityAdvertMapper {

    /**
     * 根据位置编号查询广告
     *
     * @param position 广告位
     * @return 广告实体
     */
    List<AdvertEntry> listByPositionType(Integer position);

    /**
     * 查询单个广告位的相关信息
     *
     * @param relationIds 广告ID
     * @return 广告与广告素材信息列表
     */
    List<AdvertEntry> listByRelationId(List<Long> relationIds);
}
