package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.vo.ActivityTask;
import com.bxm.fossicker.activity.model.vo.ActivityTaskListVo;
import com.bxm.fossicker.activity.model.vo.ActivityUserTask;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 任务信息表 Mapper 接口
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@Mapper
public interface ActivityTaskMapper {

    /**
     * 获取启用的日常任务列表
     * @return 日常任务列表
     */
    List<ActivityTaskListVo> listEnableTask();

    /**
     * 查询用户的任务信息
     */
    ActivityUserTask queryUserTaskById(@Param("id") Long id);

    /**
     * 查询用户的任务信息
     */
    ActivityUserTask query(@Param("userId") Long userId, @Param("taskCode") String taskCode);

    /**
     * 更新用户任务状态信息
     */
    Boolean obtain(@Param("bindId") Long bindId, @Param("preResidueTime") Integer preResidueTime, @Param("afterResidueTime") Integer afterResidueTime);

    /**
     * 更新任务状态为2：已领取
     *
     * @param userId   用户id
     * @param taskCode 任务编码
     */
    Boolean updateReward(@Param("userId") Long userId, @Param("taskCode") String taskCode);

    /**
     * 查询任务
     */
    ActivityTask queryById(@Param("id") Long id);

    /**
     * 查询任务
     */
    ActivityTask queryByTaskCode(@Param("taskCode") String taskCode);

    /**
     * 查询用户任务数量
     */
    Integer countByUserId(Long userId);

    /**
     * 查询所有可用任务
     */
    List<ActivityTask> listAll();

    /**
     * 批量添加用户任务
     */
    Boolean batchAddUserTasks(@Param("userTasks") List<ActivityUserTask> userTasks);

    /**
     * 完成任务
     */
    Boolean taskComplete(@Param("userId") Long userId, @Param("taskCode") String taskCode);

    /**
     * 完成任务
     *
     * @param id 用户任务id
     */
    void completeById(Long id);

    /**
     * 隐藏已经领取的新手任务
     */
    void hideFinishedNoviceTask();

    /**
     * 重置每日任务状态
     */
    void resetEverydayTask();

    /**
     * 添加一条任务完成信息（新手任务）
     *
     * @param activityUserTask 用户任务信息
     */
    void addOne(ActivityUserTask activityUserTask);
}
