package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.vo.ActivityWithdraw;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ActivityWithdrawMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ActivityWithdraw record);

    int insertSelective(ActivityWithdraw record);

    ActivityWithdraw selectByPrimaryKey(Long id);

    /**
     * 根据用户id查询提现机会
     * ===1.4.0版本取消有效期的校验
     * @param userId 用户id
     * @return 提现机会
     */
    List<ActivityWithdraw> selectByUserId(Long userId);

    /**
     * 根据类型查看用户提现机会  1.4.1版本
     * @param userId
     * @param type
     * @return
     */
    List<ActivityWithdraw> selectByType(@Param("userId") Long userId,@Param("type") Integer type);

    int updateByPrimaryKeySelective(ActivityWithdraw record);

    int updateByPrimaryKey(ActivityWithdraw record);

    int updateByUserId(Long userId);

    /**
     * 更改提现状态为已提现  1.4.1版本需求
     * @param userId
     * @param id
     * @param type
     * @return
     */
    int updateStatusByUserIdAndType(@Param("userId") Long userId, @Param("id") Long id, @Param("type") Integer type);
}