package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.vo.UserAddressList;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户通讯录 Mapper 接口
 * </p>
 *
 * @author XinZhao
 * @since 2019-07-02
 */
@Mapper
public interface UserAddressListMapper {

    /**
     * 通过用户id查询通讯录列表
     */
    List<UserAddressList> listByUserId(@Param("userId") Long userId);

    UserAddressList query(@Param("userId")Long userId,@Param("phone") String phone);

    Boolean addOne(UserAddressList userAddressList);

    /**
     * 批量添加通讯录
     */
    Integer batchAdd(@Param("userAddressLists") List<UserAddressList> userAddressLists);

    /**
     * 更新邀请状态
     */
    Integer updateStatus(@Param("id") Long id, @Param("status") Integer status);


    UserAddressList selectByPrimaryKey(Long id);
}
