package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.param.FriendsListParam;
import com.bxm.fossicker.activity.model.vo.UserInviteRelation;
import com.bxm.fossicker.activity.model.vo.UserInvitedVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 用户邀请关系记录 Mapper 接口
 * </p>
 *
 * @author XinZhao
 * @since 2019-07-01
 */
@Mapper
public interface UserInviteRelationMapper {

    /**
     * 添加邀请关系
     *
     * @param userInviteRelation 邀请关系实体
     * @return 添加状态
     */
    Boolean addOne(UserInviteRelation userInviteRelation);

    int deleteByPrimaryKey(Long id);


    /**
     * 查询被邀请人id为输入值，且邀请状态为成功的数量
     *
     * @param invitedId 被邀请用户id
     * @return 计数
     */
    Integer countByInvitedId(@Param("invitedId") Long invitedId);


    /**
     * 通过邀请人id查询成功的被邀请人列表
     *
     * @param userId 用户id
     * @return 被邀请人列表
     */
    List<UserInvitedVo> queryInvitedByUserId(@Param("userId") Long userId);


    /**
     * 更新今日提醒状态为已提醒
     *
     * @param userId    邀请人id
     * @param invitedId 被邀请人id
     * @return 更新数
     */
    Integer updateRemindStatus(@Param("userId") Long userId, @Param("invitedId") Long invitedId);

    /**
     * 更新绑定状态
     *
     * @param userId    邀请人id
     * @param invitedId 被邀请人id
     * @return 更新数
     */
    Integer updateBindStatus(@Param("userId") Long userId, @Param("invitedId") Long invitedId);

    /**
     * 更新邀请关系
     *
     * @param userId    邀请人id
     * @param invitedId 被邀请人id
     * @return 更新数
     */
    Integer updateInviteType(@Param("userId") Long userId, @Param("invitedId") Long invitedId,@Param("inviteType") String inviteType);

    void initRemindStatus();

    /**
     * 根据被邀请用户id查询邀请关系
     * @param invitedId 被邀请人id
     * @return
     */
    UserInviteRelation selectByInvitedUserId(Long invitedId);

    /**
     * 查看好友总数
     * @param userId 用户id
     * @return 好友总数
     */
    int selectFriendsNumByUserId(Long userId);

    /**
     * 获取收益
     * @param userId
     * @return
     */
    BigDecimal getEarning(Long userId);

    /**
     * 查看好友总数-现金奖励版本的用户
     * @param userId 用户id
     * @return 好友总数
     */
    int selectFriendsNumByUserIdAndVersion(Long userId);

    /**
     * 获取好友列表信息-状态为1且邀请类型为1(现金收益)
     * @param userId 用户id
     * @return
     */
    List<UserInviteRelation> getFriendsListInfo(Long userId);

    /**
     * 获取全部好友信息
     * @param friendsListParam 请求参数
     * @return
     */
    List<UserInviteRelation> getAllFriendsListInfo(FriendsListParam friendsListParam);

    /**
     * 根据被邀请人id和状态为0的条件查询
     * @param invitedId 被邀请人id
     * @return
     */
    UserInviteRelation selectByInvitedIdAndStatus(Long invitedId);

    /**
     * 获取金币奖励版本下的old好友列表
     * @return
     */
    List<UserInviteRelation> selectOldFriends();

    /**
     * 获取可奖励vip的用户list
     * @param userId 用户id
     * @return 可奖励vip的用户list
     */
    List<UserInviteRelation> getRewardVipUserList(Long userId);

    /**
     * 根据id更新vip消费状态
     * @param id 主键id
     * @return 更新结果
     */
    Integer updateConsumeStatusById(Long id);

    /**
     * 根据邀请者和被邀请者id查询
     * @param userId 邀请人id
     * @param invitedId 被邀请人id
     * @return 关联信息
     */
    UserInviteRelation selectByUserAndInvitedId(@Param("userId") Long userId, @Param("invitedId") Long invitedId);

    /**
     * 奖励登录-earning +1元
     * @param userId 用户id
     * @param invitedId 被邀请人id
     * @param rewardAmt 奖励金额
     * @return 请求结果
     */
    Integer rewardLogin(@Param("userId") Long userId, @Param("invitedId") Long invitedId, @Param("rewardAmt") BigDecimal rewardAmt);

    /**
     * 奖励登录-earning +1元
     * @param userId 用户id
     * @param invitedId 被邀请人id
     * @param goldRewardAmt 金币奖励
     * @param rewardAmt 现金奖励
     * @return 请求结果
     */
    Integer rewardVip(@Param("userId") Long userId,
                      @Param("invitedId") Long invitedId,
                      @Param("rewardAmt") BigDecimal rewardAmt,
                      @Param("goldRewardAmt") Integer goldRewardAmt);

    /**
     * 获取用户首次现金邀请奖励的邀请记录
     * @param userId
     * @return
     */
    UserInviteRelation getFirstSuccessCashInviteRelationInfo(Long userId);
}
