package com.bxm.fossicker.activity.domain.debris;

import com.bxm.fossicker.activity.model.entity.ActivityAwardPhaseEntity;
import com.bxm.fossicker.activity.model.param.debris.ActivityUserPageParam;
import com.bxm.fossicker.activity.model.vo.debris.MyActivityAwardVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ActivityAwardPhaseMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ActivityAwardPhaseEntity record);

    int insertSelective(ActivityAwardPhaseEntity record);

    ActivityAwardPhaseEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ActivityAwardPhaseEntity record);

    int updateByPrimaryKey(ActivityAwardPhaseEntity record);

    /**
     * 获取用户奖品列表
     *
     * @param userId    用户id
     * @param pageParam 分页参数
     * @return 奖品列表
     */
    List<MyActivityAwardVo> getUserAwardPhaseList(ActivityUserPageParam userPageParam);

    /**
     * 获取当前活动期数信息
     *
     * @param activityAwardId 奖品活动id
     * @param userId          用户id
     * @return 活动期数信息
     */
    ActivityAwardPhaseEntity getCurrentPhaseInfo(@Param("activityAwardId") Long activityAwardId,
                                                 @Param("userId") Long userId);

    /**
     * 增加当前期数获取的碎片个数
     *
     * @param phaseId 期数id
     * @return 改变行数
     */
    int increasePhaseDebrisNum(@Param("phaseId") Long phaseId);

    /**
     * 获取可用期数通过id和用户id查询
     *
     * @param phaseId 期数id
     * @param userId  用户id
     * @return 期数信息
     */
    ActivityAwardPhaseEntity selectAvailablePhase(@Param("phaseId") Long phaseId,
                                                  @Param("userId") Long userId);

    /**
     * 清理所有已失效的活动期数
     *
     * @return 影响行数
     */
    int clearExpiredPhase();

}