package com.bxm.fossicker.activity.domain.debris;

import com.bxm.fossicker.activity.model.entity.ActivityAwardPhaseRecordEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ActivityAwardPhaseRecordMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ActivityAwardPhaseRecordEntity record);

    int insertSelective(ActivityAwardPhaseRecordEntity record);

    ActivityAwardPhaseRecordEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ActivityAwardPhaseRecordEntity record);

    int updateByPrimaryKey(ActivityAwardPhaseRecordEntity record);

    /**
     * 获取今天碎片领取记录通过活动奖品id和用户id
     *
     * @param activityAwardId 活动奖品id
     * @param userId          用户id
     * @return 碎片领取记录
     */
    List<ActivityAwardPhaseRecordEntity> getRecordListByActivityAwardIdAndUserId(
            @Param("activityAwardId") Long activityAwardId,
            @Param("userId") Long userId);

    /**
     * 获取领取记录通过期数id（v2.2.2版本去除了期数的概念，其实是固定的期数）
     *
     * @param phaseId 期数id
     * @return 领取记录
     */
    List<ActivityAwardPhaseRecordEntity> getRecordListByPhaseId(@Param("phaseId") Long phaseId);

}