package com.bxm.fossicker.activity.domain.debris;


import com.bxm.fossicker.activity.model.entity.ActivityRedPacketRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ActivityRedPacketRecordMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ActivityRedPacketRecord record);

    int insertSelective(ActivityRedPacketRecord record);

    ActivityRedPacketRecord selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ActivityRedPacketRecord record);

    int updateByPrimaryKey(ActivityRedPacketRecord record);

    /**
     * 获取今天的红包领取记录，通过红包id
     *
     * @param userId      用户id
     * @param redPacketId 红包id
     * @return 领取记录列表
     */
    List<ActivityRedPacketRecord> getTodayRecordByRedPacketId(@Param("userId") Long userId,
                                                              @Param("redPacketId") Long redPacketId);
}