package com.bxm.fossicker.activity.domain.lottery;

import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryPageParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryBean;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface LotteryMapper {
    int deleteByPrimaryKey(Long id);

    int insert(LotteryBean record);

    int insertSelective(LotteryBean record);

    LotteryBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(LotteryBean record);

    int updateByPrimaryKey(LotteryBean record);

    /**
     * 活动增加期数
     *
     * @param lotteryId 活动ID
     * @return 操作熟练
     */
    int addNum(Long lotteryId);

    /**
     * 分页查询抽奖活动信息
     *
     * @param param 分页参数
     * @return 分页结果集
     */
    List<LotteryBean> getLotteryByPage(LotteryQueryPageParam param);

    /**
     * 获取排序位置存在的活动
     *
     * @param order 排序位置
     * @return 活动ID
     */
    List<Long> getLotteryByOrder(int order);

    /**
     * 将order之后的活动排序+1
     *
     * @param order 排序位置
     * @return 更新行数
     */
    int updateOrder(int order);
}