package com.bxm.fossicker.activity.domain.lottery;

import com.bxm.fossicker.activity.model.dto.lottery.LotteryHistoryDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryParticipantDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.activity.model.vo.lottery.JoinHistoryBean;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryParticipantBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface LotteryParticipantMapper {
    int deleteByPrimaryKey(Long id);

    int insert(LotteryParticipantBean record);

    int insertSelective(LotteryParticipantBean record);

    LotteryParticipantBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(LotteryParticipantBean record);

    int updateByPrimaryKey(LotteryParticipantBean record);

    /**
     * 获取某一期活动参与的真实用户数量
     *
     * @param phaseId 活动期ID
     * @return 参与人数
     */
    int getRealUserCount(Long phaseId);

    /**
     * 查询用户的参与历史记录
     *
     * @param userId 用户ID
     * @return 参与记录
     */
    List<JoinHistoryBean> getUserJoinHistory(Long userId);

    /**
     * 分页查询活动参与人员信息
     *
     * @param param 查询参数
     * @return 分页结果
     */
    List<LotteryParticipantDTO> getParticipantByPage(LotteryPhaseQueryParam param);

    /**
     * 查询活动参与的真实用户信息（不分页）
     * @param phaseId
     * @param userType
     * @return
     */
    List<LotteryParticipantDTO> getParticipant(@Param("phaseId") Long phaseId, @Param("userType") Byte userType);

    /**
     * 获取用户参与的活动列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<LotteryHistoryDTO> getUserHistoryByPage(LotteryQueryParam param);

    /**
     * 获取用户参与的编码数量
     *
     * @param phaseId 活动期ID
     * @param userId  用户ID
     * @return 用户参与某一期的全部中奖编码
     */
    List<String> getJoinHistoryCodes(@Param("phaseId") Long phaseId, @Param("userId") Long userId);

    /**
     * 获取本期活动所有参与的虚拟用户
     *
     * @return 虚拟用户的中奖编码
     */
    List<LotteryParticipantDTO> getVitrualUser(Long phaseId);
}