package com.bxm.fossicker.activity.domain.lottery;

import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryCompleteDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseDetailDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryPhaseBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface LotteryPhaseMapper {
    int deleteByPrimaryKey(Long id);

    int insert(LotteryPhaseBean record);

    int insertSelective(LotteryPhaseBean record);

    LotteryPhaseBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(LotteryPhaseBean record);

    int updateByPrimaryKey(LotteryPhaseBean record);

    /**
     * 获取活动最后一期
     *
     * @param lotteryId 活动ID
     * @param status    对应的状态
     * @return 活动期状态
     */
    LotteryPhaseBean getLastPhase(@Param("lotteryId") Long lotteryId,
                                  @Param("status") Integer status);

    /**
     * 设置活动的最后一期ID，用于定位最新一期活动
     *
     * @param lotteryId 活动ID
     * @param phaseId   最新一期活动ID
     * @return 操作结果
     */
    int setLastPhaseId(@Param("lotteryId") Long lotteryId, @Param("phaseId") Long phaseId);

    /**
     * 获取活动的全部期数数据，排查当前参数中的期数ID
     *
     * @param lotteryId 活动ID
     * @param phaseId   期数ID
     * @return 期数ID
     */
    List<Long> getAllPhaseByLottery(@Param("lotteryId") Long lotteryId, @Param("phaseId") Long phaseId);

    /**
     * 分页获取进行中的活动期列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<LotteryDTO> getPhaseByPage(LotteryQueryParam param);

    /**
     * 获取第一条活跃的活动
     */
    LotteryDTO getTopActivePhase();

    /**
     * 获取近期开奖记录列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<LotteryCompleteDTO> getPhaseCompleteByPage(LotteryPhaseQueryParam param);

    /**
     * 获取活动历史开奖记录
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<LotteryCompleteDTO> getPhaseDrawByPage(LotteryQueryParam param);

    /**
     * 活动期详情
     *
     * @param phaseId 活动期ID
     * @return 详情信息
     */
    LotteryPhaseDetailDTO getDetail(Long phaseId);

    /**
     * 获取所有进行中的活动
     *
     * @return 进行中的活动ID
     */
    List<Long> getGoingPhase();
}