package com.bxm.fossicker.activity.facade;

import com.bxm.fossicker.activity.facade.constant.ActivityWithdrawType;
import com.bxm.fossicker.activity.facade.model.ActivityWithdrawDto;
import com.bxm.fossicker.activity.facade.model.ActivityWithdrawNewDto;

import java.util.List;

/**
 * @ClassName ActivityWithdrawFacadeService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author zhaoxin
 * @Date 2019/7/24 13:21
 * @Version 1.0.0
 **/
public interface ActivityWithdrawFacadeService {

    /**
     * 获取用户可用的活动提现列表
     * @param userId 用户id
     */
    List<ActivityWithdrawDto> list(Long userId);

    /**
     * 根据类型获取用户可提现列表  1.4.1 新增提现类型
     * @param  userId userId
     * @param type {@link ActivityWithdrawType}
     * @return
     */
    List<ActivityWithdrawNewDto> list(Long userId, Integer type);

    /**
     * 使用掉活动提现
     * @param userId 用户id
     */
    void used(Long userId);

    /**
     *
     * @param userId
     * @param id
     * @param type {@link ActivityWithdrawType}
     */
    void used(Long userId,Long id,Integer type);

}
