package com.bxm.fossicker.activity.facade;

import com.bxm.fossicker.activity.facade.enums.InviteTypeEnum;
import com.bxm.newidea.component.vo.Message;

import java.math.BigDecimal;

public interface InviteRelationFacadeService {

    /**
     * 获取成功邀请的好友-弹窗需求(仅记录成功邀请的好友数)
     * @param userId 用户id
     * @return
     */
    Integer getSuccessInvitationInfo(Long userId);

    /**
     * 删除成功邀请的好友-弹窗需求
     * @param userId 用户id
     * @return 删除结果
     */
    Boolean removeSuccessInvitation(Long userId);

    /**
     * 成功绑定绑定邀请关系
     *
     * @param userId         用户id
     * @param superiorUserId 上级用户id
     * @return
     */
    Boolean bindSuccessRelation(Long userId, Long superiorUserId);

    /**
     * 更新现金奖励vip信息
     * @param userId 用户id
     * @param invitedId 被邀请人id
     * @return 更新结果
     */
    Boolean updateRewardVip(Long userId, Long invitedId, BigDecimal rewardAmt);

    /**
     * 更新金币奖励vip信息
     * @param userId 用户id
     * @param invitedId 被邀请人id
     * @return 更新结果
     */
    Boolean updateGoldRewardVip(Long userId, Long invitedId, Integer rewardAmt);

    /**
     * 完成绑定信息之后，真正的邀请成功
     * 会给邀请人发送邀请奖励，并标记为真正成功
     * @param invitedId 被邀请人id
     * @param userId 邀请人id
     * @return 请求结果
     */
    Message inviteFinalSuccess(Long invitedId, Long userId);

    /**
     * 更新邀请表里的邀请关系
     * @param userId
     * @param superiorUserId
     * @return
     */
    Message updateInviteType(Long userId, Long superiorUserId, InviteTypeEnum inviteTypeEnum);
}
