package com.bxm.fossicker.activity.facade;

import com.bxm.fossicker.activity.facade.model.SignFacadeDto;

import java.util.Date;

/**
 * 福利社
 * @authoer Gonzo
 * @date 2019-09-03 12:26
 */
public interface SignFacadeService {

    /**
     * 是否签到过
     * @param userId 查询用户
     * @param date 查询的日期
     * @return
     */
    Boolean didSign(Long userId, Date date);

    /**
     * 获取签到信息-确保当天已经签到过
     * @param userId
     * @return
     */
    SignFacadeDto getSignInfo(Long userId);


    /**
     * 签到
     * @param userId 用户id
     * @return true-签到成功,false-签到失败
     */
    boolean signByDay(Long userId);

    /**
     * 得到今天的签到奖励
     * @param userId
     * @return
     */
    Integer getTodaySignReward(Long userId);


}
