package com.bxm.fossicker.activity.facade;

import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityTaskFacadeDTO;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.activity.facade.model.DayGoldFacadeDto;

/**
 * 任务内部服务
 *
 * @author xin.zhao
 **/
public interface TaskFacadeService {
    /**
     * 活动完成调用
     *
     * @param userId   任务id
     * @param activityFacadeEnum 对内服务活动枚举 查看枚举类
     * @see ActivityFacadeEnum
     */
    Boolean complete(Long userId, ActivityFacadeEnum activityFacadeEnum);

    /**
     * 为新用户创建天天领现金活动，第一个红包的可领取时间为当天
     * <p>
     * 以今日日期为七点，创建7日的红包数据
     *
     * @param userId 用户id
     */
    void createDayGold(Long userId);


    /**
     * 查询用户的天天领现金活动信息
     * @param userId 用户id
     * @return 天天领现金活动信息
     */
    DayGoldFacadeDto dayGoldInfo(Long userId);

    /**
     * 查询用户的任务信息
     */
    ActivityUserTaskFacadeDTO queryUserTask(Long userId, ActivityFacadeEnum activityFacadeEnum);

    /**
     * 根据任务id获取任务信息
     */
    ActivityTaskFacadeDTO queryById(Long taskId);

}
