package com.bxm.fossicker.activity.facade.enums;

/**
 * 内部服务活动枚举
 *
 * @author xin.zhao
 */
public enum ActivityFacadeEnum {

    //========新手任务=======
    INPUT_INVITE("输入邀请码", 0),
    VIEW_GOODS("逛商品赚金币", 0),
    VIEW_VIDEO("观看视频教程", 0),
    SEARCH_TITLE("淘宝标题搜券", 0),
    AUTH_TAOBAO("授权淘宝", 0),
    FIRST_SHOP("完成首次购物", 0),
    BIND_WECHAT("微信授权", 0),
    FINISH_PERSONAL_INFO("完善我的标签", 0),

    //==========普通活动========
    FINISH_VIEW("完成浏览商品10S", 1),
    SHARE_VIEW("分享商品被浏览", 1);

    private String task;
    /**
     * 活动类型 0：新手任务 1：普通活动
     */
    private Integer type;

    ActivityFacadeEnum(String task, Integer type) {
        this.task = task;
        this.type = type;
    }

    public String getTask() {
        return this.task;
    }

    public Integer getType() {
        return type;
    }
}
