package com.bxm.fossicker.activity.lottery.service;

import com.bxm.fossicker.activity.model.dto.lottery.LotteryChanceDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryHistoryDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryParticipantDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseJoinDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryDrawParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.vo.PageWarper;

import java.util.Map;

/**
 * 全民抽奖-活动参与者服务接口
 *
 * @author liujia
 */
public interface LotteryParticipantService {

    /**
     * 用户参与某一期抽奖活动
     * 判断活动当前状态是否允许加入
     * 判断用户剩余次数是否足够
     * 判断单个活动参与次数是否足够
     * <p>
     * 剩余抽奖次数为0时，活动开奖
     *
     * @param param 抽奖参数
     * @return 参与结果
     */
    LotteryPhaseJoinDTO addParticipant(LotteryDrawParam param);

    /**
     * 给活动增加虚拟用户参加记录
     *
     * @param phaseId 活动期ID
     */
    void addVirtualUser(Long phaseId);

    /**
     * 获取用户参与的每一期次数记录
     *
     * @param userId  用户ID
     * @param phaseId 活动期ID，参数为空则查询用户所有的参与记录
     * @return 参与记录MAP，key为phaseId，value为对应的次数
     */
    Map<String, Integer> loadJoinHistoryMap(Long userId, Long phaseId);

    /**
     * 分页查询活动参与者列表
     *
     * @param param 查询参数
     * @return 分页结果
     */
    PageWarper<LotteryParticipantDTO> getParticipantList(LotteryPhaseQueryParam param);

    /**
     * 获取用户的剩余抽奖次数，如果无次数，则提示下次抽奖时间
     *
     * @param userId 用户ID
     * @return 抽奖次数信息
     */
    LotteryChanceDTO getUserChance(Long userId);

    /**
     * 我参与的活动历史记录
     * @param param 分页参数
     * @return 分页结果
     */
    PageWarper<LotteryHistoryDTO> getHistoryPhaseList(LotteryQueryParam param);
}
