package com.bxm.fossicker.activity.lottery.service;

import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryPageParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryBean;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.vo.Message;

/**
 * 全名抽奖-基础信息服务接口
 */
public interface LotteryService {
    /**
     * 创建抽奖活动，创建的活动默认为未启用状态
     *
     * @param entity 活动信息
     * @return 保存结果
     */
    Message addLottery(LotteryBean entity);

    /**
     * 变更抽奖信息
     * 1.变更抽奖活动信息
     * 2.同步变更最新一期的活动
     *
     * @param entity 变更的活动信息
     * @return 变更结果
     */
    Message modify(LotteryBean entity);

    /**
     * 将活动标记为删除状态
     * 如果存在最新一期的活动并且全部用户为虚拟用户，则关闭最新一期
     *
     * @param lotteryId 活动ID
     * @param operator 操作人ID
     * @return 删除结果
     */
    Message remove(Long lotteryId, Long operator);

    /**
     * 变更活动状态
     *
     * @param lotteryId 活动ID
     * @param status    活动状态，0：禁用，1：启用
     * @return 变更结果
     */
    Message change(Long lotteryId, Byte status);

    /**
     * 从缓存中加载活动信息
     *
     * @param lotteryId 活动ID
     * @return 活动详情
     */
    LotteryBean loadCache(Long lotteryId);

    /**
     * 分页查询活动信息
     *
     * @param param 分页参数
     * @return 分页活动信息
     */
    PageWarper<LotteryBean> getByPage(LotteryQueryPageParam param);
}
