package com.bxm.fossicker.activity.lottery.timer;

import com.bxm.fossicker.activity.domain.lottery.LotteryPhaseMapper;
import com.bxm.fossicker.activity.lottery.service.LotteryParticipantService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 给进行中的活动增加虚拟用户
 */
@Component
public class LotteryVirtualTimer extends AbstractCronTask<Long> {

    private final LotteryParticipantService lotteryParticipantService;

    private final LotteryPhaseMapper lotteryPhaseMapper;

    @Autowired
    public LotteryVirtualTimer(LotteryParticipantService lotteryParticipantService,
                               LotteryPhaseMapper lotteryPhaseMapper) {
        this.lotteryParticipantService = lotteryParticipantService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
    }

    @Override
    protected ReturnT<String> service(Long param) {
        List<Long> goingPhase = lotteryPhaseMapper.getGoingPhase();

        if (!CollectionUtils.isEmpty(goingPhase)) {
            goingPhase.forEach(lotteryParticipantService::addVirtualUser);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String description() {
        return "给进行中的活动增加虚拟用户";
    }

    @Override
    public String taskName() {
        return LotteryVirtualTimer.class.getSimpleName();
    }

    @Override
    public String cron() {
        return "0/5 * 7-22 * * ?";
    }
}
