package com.bxm.fossicker.activity.service;

import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.activity.model.param.ActivitiesParam;
import com.bxm.fossicker.activity.model.param.UserIdParam;
import com.bxm.fossicker.activity.model.vo.TemporaryActivityVO;
import com.bxm.newidea.component.vo.Message;

/**
 * Created by Gonzo on 2019-08-12.
 * 活动相关service
 */
public interface TemporaryActivityService {

    /**
     * app启动，获取活动信息
     *
     * @param param
     * @return
     */
    TemporaryActivityVO activities(ActivitiesParam param);

    /**
     * 获取登录奖励
     * @param param 用户id
     * @return 领取成功与否
     */
    Message loginReward(UserIdParam param);

    /**
     * 获取登录奖励信息
     * @param userId 用户id
     * @return 登录奖励信息
     */
    LoginRewardFacadeDTO loginRewardInfo(Long userId);
}
