package com.bxm.fossicker.activity.service.advert;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;

import java.util.List;

/**
 * 广告过滤器
 *
 * @author Gonzo
 * @date 2019-08-21 09:53
 */
public interface AdvertisementFilter {

    /**
     * 过滤广告
     *
     * @param advertDtos 要过滤的广告集合
     * @param param      过滤过程中需要的参数
     * @return 是否执行下一个过滤器, true：继续执行
     */
    boolean filter(List<AdvertDto> advertDtos, AdvertisementFilterParam param);
}
