package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.enums.VipTypeEnum;

import java.util.List;

/**
 * 判断用户是否开通VIP的过滤器
 *
 * @author liujia
 * @date 2020/03/23 16:38
 */
@AdverFilter
public class OpenVipFilter extends AbstractAdvertisementFilter {
    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        advertDtos.removeIf(advert -> {
            if (advert.getOpenVip() != null && advert.getOpenVip() != 0) {
                UserInfoDto user = param.getUserInfoDto();

                //条件为已开卡，用户如果未开卡则不显示
                if (advert.getOpenVip() == 1 && user.getVip() != VipTypeEnum.VIP_FOREVER.getType()) {
                    return true;
                }

                //条件为未开卡，用户如果已经开卡则不显示
                return advert.getOpenVip() == 2 && user.getVip() == VipTypeEnum.VIP_FOREVER.getType();
            }
            return false;
        });
        return true;
    }
}
