package com.bxm.fossicker.activity.service.advert.filter.general;

import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * 淘气365权益广告
 * 需要在配置的广告中增加签名处理，对占位符进行填充
 *
 * @author liujia
 * @date 2020/03/10 15:09
 */
@AdverFilter
public class Taoqi365AdvertisementFilter extends AbstractAdvertisementFilter {

    private final ActivityProperties activityProperties;

    private final static String URL_PREFIX = "http://tq.jfshou.cn";

    @Autowired
    public Taoqi365AdvertisementFilter(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        advertDtos.forEach(item -> {
            if (StringUtils.startsWith(item.getUrl(), URL_PREFIX)) {
                item.setUrl(parseUrl(item.getUrl(), param));
            }
        });
        return true;
    }

    /**
     * 解析原始url，进行路径处理
     *
     * @param sourceUrl 运营配置的淘气权益365商品地址
     * @return 处理后的地址
     */
    private String parseUrl(String sourceUrl, AdvertisementFilterParam param) {
        if (StringUtils.isBlank(sourceUrl)) {
            return sourceUrl;
        }
        //增加用户唯一码
        if (sourceUrl.contains("?")) {
            sourceUrl += "&";
        } else {
            sourceUrl += "?";
        }
        sourceUrl += "machineCode=" + param.getAdvertParam().getUserId();

        // 代理商ID
        sourceUrl += "&agentId=" + activityProperties.getTaoqi365AgentId();

        //时间戳
        sourceUrl += "&timestamp=" + System.currentTimeMillis();

        //解析URL获取参数信息，计算签名
        List<NameValuePair> paramList = URLEncodedUtils.parse(StringUtils.substring(sourceUrl, sourceUrl.indexOf("?") + 1), UTF_8);

        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName))
                .collect(Collectors.toList());

        StringBuilder signSource = new StringBuilder();

        for (NameValuePair nameValuePair : paramList) {
            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }

        signSource.append("secretKey").append("=").append(activityProperties.getTaoqi365SecertKey());

        // 附加签名
        sourceUrl += "&sign=" + MD5Util.hgmd5(signSource.toString()).toUpperCase();

        return sourceUrl;
    }
}
