package com.bxm.fossicker.activity.service.advert.filter.position;

import com.bxm.fossicker.activity.config.AdvertConfig;
import com.bxm.fossicker.activity.model.dto.AdvertDto;
import com.bxm.fossicker.activity.model.enums.AdvertPositionEnum;
import com.bxm.fossicker.activity.service.advert.annotation.AdverFilter;
import com.bxm.fossicker.activity.service.advert.bo.AdvertisementFilterParam;
import com.bxm.fossicker.activity.service.advert.impl.AbstractAdvertisementFilter;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.enums.VipTypeEnum;
import com.bxm.newidea.component.tools.DateUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 我的页面顶部按钮
 */
@AdverFilter(AdvertPositionEnum.USER_PAGE_TOP_BUTTON)
public class MinePageTopIconFilter extends AbstractAdvertisementFilter {

    @Resource
    private AdvertConfig advertConfig;

    @Override
    protected boolean doFilter(List<AdvertDto> advertDtos, AdvertisementFilterParam param) {
        UserInfoDto user = param.getUserInfoDto();

        if (removeInputInviteCode(user,param)) {
            // 移除邀请码
            advertDtos.removeIf(p -> Objects.equals(p.getTitle(), advertConfig.getMinePageTopInputInviteCodeIconName()));

        } else {
            int registerDays = getRegisterDays(param);
            if (registerDays > advertConfig.getInputInviteCodeShowDays()) {
                // 超过3天(暂时默认为3天) 则移除邀请码
                advertDtos.removeIf(p -> Objects.equals(p.getTitle(), advertConfig.getMinePageTopInputInviteCodeIconName()));
            } else {
                // 移除邀请好友
                advertDtos.removeIf(p -> Objects.equals(p.getTitle(), advertConfig.getMinePageTopInviteUserIconName()));
            }
        }

        if (user.getVip() == VipTypeEnum.VIP_FOREVER.getType()) {
            advertDtos.removeIf(p -> Objects.equals(p.getTitle(), advertConfig.getMinePageTopFreeGetVip()));
        }

        return true;
    }

    /**
     * 如果有上级
     * 或者是特殊渠道的用户 -> 隐藏填邀请码的入口
     * @param user
     * @param param
     * @return
     */
    private Boolean removeInputInviteCode(UserInfoDto user, AdvertisementFilterParam param) {
        return (Objects.nonNull(user.getSuperiorUserId()) && !Objects.equals(user.getSuperiorUserId(), 0L)) ||
                param.getUserInfoFacadeService().checkIsSpecialRegChannel(user.getRegChannel());
    }

    private int getRegisterDays(AdvertisementFilterParam param) {
        UserInfoDto userInfo = param.getUserInfoDto();
        if (null == userInfo) {
            return -1;
        }

        if (userInfo.getCreateTime() == null) {
            return -1;
        }

        return DateUtils.getDiffDays(userInfo.getCreateTime(), new Date(), true);
    }
}
