package com.bxm.fossicker.activity.service.config;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Created by Gonzo on 2019-08-09.
 */
@ConfigurationProperties(prefix = "activity")
@Data
@Component
public class ActivityProperties {

    /**
     * 邀请好友注册的url
     */
    private String inviteUserUrl;

    /**
     * 提现类型
     */
    private Map<String, Integer> withdrawType = Maps.newHashMap();

    /**
     * 宝箱奖励金币
     */
    private String boxAwardGold;

    /**
     * 邀请用户获取vip奖励的人数
     */
    private Integer inviteUserRewardNum;

    /**
     * 每邀请一名用户获得的现金奖励数
     */
    private String inviteUserReward;

    /**
     * 广告策略列表配置项
     */
    private String advertStrategyConfigList;

    /**
     * 每四个小时的抽奖次数，每日零点清空
     */
    private long maxChances = 5L;

    /**
     * 用户抽奖次数循环周期（秒）
     */
    private long loopSeconds = 3600 * 4L;

    /**
     * 每半个小时增加虚拟用户的最少数量
     */
    private int virtualMinNum = 15;

    /**
     * 每半个小时增加虚拟用户的最多数量
     */
    private int virtualMaxNum = 30;

    /**
     * 活动中奖编码前缀
     */
    private int codePrefix = 10000001;

    /**
     * 每日福利奖励金币数量（观看视频增加后）
     */
    private int dailyWelfare = 120;

    /**
     * 默认的每日福利奖励金币
     */
    private int defaultDailyWelfare = 100;

    /**
     * 淘气365商城的用户ID
     */
    private String taoqi365AgentId = "706";

    /**
     * 淘气365商城的密钥
     */
    private String taoqi365SecertKey = "TbhnzdNf8NrwwTNwp7bfzPmp2DP3BfNK";
}
