package com.bxm.fossicker.activity.service.config;

import com.bxm.fossicker.activity.model.DayRewardModel;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName SignConfig
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/3 11:43
 * @Version 1.0.0
 **/
@Component
@Data
@ConfigurationProperties("activity.config.sign")
public class SignConfig {
    /**
     * 签到周期：目前为15天
     */
    private Integer circle;

    /**
     * 周期签到奖励金币
     */
    private Integer circleReward;

    /**
     * 每日奖励JSON
     */
    private List<DayRewardModel> dayReward;

    /**
     * 签到天数对应的活动提现金额 json
     */
    private String withdrawDays;

    /**
     * 新版本的签到天数
     */
    private Integer newSingDays = 15;
}
