package com.bxm.fossicker.activity.service.dispatcher;

import com.bxm.fossicker.activity.model.enums.NewUserTaskEnum;
import com.bxm.fossicker.activity.service.task.action.ActivityTaskAction;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 任务行为适配器
 *
 * @author xin.zhao
 */
@Component
public class TaskActionDispatcher implements ApplicationContextAware {

    private Map<String, ActivityTaskAction> taskActionMap;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        taskActionMap = applicationContext.getBeansOfType(ActivityTaskAction.class);
    }

    public ActivityTaskAction getByTaskCode(String taskCode) {
        if (NewUserTaskEnum.getNewUserTaskNames().contains(taskCode)) {
            // 新手任务
            return taskActionMap.get("new_user_task");
        } else {
            if (taskCode.equals("WATCH_VIDEO")) {// 看视频3次特殊处理,后续日常任务都是点击即完成
                return taskActionMap.get("daily_task_watch_video");
            }
            // 日常任务
            return taskActionMap.get("daily_task");
        }
    }

}
