package com.bxm.fossicker.activity.service.gold.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.enums.DoubleGoldTypeEnum;
import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.gold.DoubleGoldService;
import com.bxm.fossicker.activity.service.gold.strategy.DoubleGoldStrategyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
@Slf4j
public class DoubleGoldServiceImpl implements DoubleGoldService {

    @Resource(name = "doubleGoldByBoxService")
    private DoubleGoldStrategyService doubleGoldByBoxService;

    @Resource(name = "doubleGoldByBrowseService")
    private DoubleGoldStrategyService doubleGoldByBrowseService;

    @Resource(name = "doubleGoldBySignService")
    private DoubleGoldStrategyService doubleGoldBySignService;

    @Resource(name = "doubleGoldByTaskService")
    private DoubleGoldStrategyService doubleGoldByTaskService;

    @Resource(name = "doubleGoldByNewbieGoldService")
    private DoubleGoldStrategyService doubleGoldByNewbieGoldService;


    @Override
    public Integer doubleGoldByType(GoldDoubleParam goldDoubleParam) {
        DoubleGoldStrategyService doubleGoldStrategyService = serviceFactory(goldDoubleParam.getType());

        if (null == doubleGoldStrategyService) {
            log.error("根据类型创建对象失败,参数为:{}", JSON.toJSONString(goldDoubleParam));
            return null;
        }
        return doubleGoldStrategyService.doubleGold(goldDoubleParam);
    }

    private DoubleGoldStrategyService serviceFactory(Integer type) {
        DoubleGoldTypeEnum doubleGoldTypeEnum = DoubleGoldTypeEnum.getEnumByType(type);


        DoubleGoldStrategyService doubleGoldStrategyService;
        switch (doubleGoldTypeEnum) {

            case BOX:
                doubleGoldStrategyService = this.doubleGoldByBoxService;
                break;

            case BROWSE:
                doubleGoldStrategyService = this.doubleGoldByBrowseService;
                break;

            case SIGN:
                doubleGoldStrategyService = this.doubleGoldBySignService;
                break;

            case TASK:
                doubleGoldStrategyService = this.doubleGoldByTaskService;
                break;

            case NEWBIE_GOLD:
                doubleGoldStrategyService = this.doubleGoldByNewbieGoldService;
                break;

            case UNDEFINED:
                return null;
            default:
                return null;
        }


        return doubleGoldStrategyService;

    }


}
