package com.bxm.fossicker.activity.service.gold.strategy;

import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 翻倍奖励抽象类
 */
public abstract class AbstractDoubleGoldStrategyService implements DoubleGoldStrategyService {

    /**
     * 账户facade服务
     */
    @Autowired
    private AccountFacadeService accountFacadeService;

    /**
     * 展示奖励金币数-现在是展示3倍
     *
     * @param awardGoldNum 实际金币奖励数
     * @return 展示的金币奖励数
     */
    public Integer showGoldNum(Integer awardGoldNum, String currentVersion) {
        if (StringUtils.compareVersion(currentVersion, "1.3.0") < 0) {
            return 2 * awardGoldNum;
        }

        return 3 * awardGoldNum;
    }

    /**
     * 向账户增加金币
     *
     * @param rewardNum       奖励金币数
     * @param goldDoubleParam 金币翻倍参数
     */
    public void addGold(BigDecimal rewardNum, GoldDoubleParam goldDoubleParam) {

        String currentVersion = goldDoubleParam.getCurVer();
        BigDecimal rewardNumDouble = rewardNum.multiply(new BigDecimal("2"));
        if (StringUtils.compareVersion(currentVersion, "1.3.0") < 0) {
            rewardNumDouble = rewardNum;
        }


        //现需求为额外奖励金币为原奖励的2倍
        //向账户添加金币
        GoldRebateParam goldRebateParam = GoldRebateParam
                .builder()
                .amount(rewardNumDouble)
                .userGoldFlowType(UserGoldFlowTypeEnum.DOUBLE_AWARD)
                .userId(goldDoubleParam.getUserId())
                .relationId(StringUtils.isBlank(goldDoubleParam.getRelationId()) ? 0L
                        : Long.parseLong(goldDoubleParam.getRelationId()))
                .build();

        accountFacadeService.goldRebate(goldRebateParam);
    }
}
