package com.bxm.fossicker.activity.service.gold.strategy.impl;

import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.gold.strategy.AbstractDoubleGoldStrategyService;
import com.bxm.fossicker.commodity.facade.CommodityGoldFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 浏览商品翻倍奖励
 */
@Service("doubleGoldByBrowseService")
public class DoubleGoldByBrowseServiceImpl extends AbstractDoubleGoldStrategyService {


    @Autowired
    private CommodityGoldFacadeService commodityGoldFacadeService;

    @Override
    public Integer doubleGold(GoldDoubleParam goldDoubleParam) {
        Integer awardNum = commodityGoldFacadeService.getBrowseGoldNum();


        //获取翻倍浏览金币,增加2次浏览上线次数
        commodityGoldFacadeService.addLimitTimesByDoubleGold(goldDoubleParam.getUserId());

        //向账户添加金币
        addGold(new BigDecimal(awardNum), goldDoubleParam);
        return showGoldNum(awardNum, goldDoubleParam.getCurVer());
    }
}
