package com.bxm.fossicker.activity.service.gold.strategy.impl;

import com.bxm.fossicker.activity.model.param.GoldDoubleParam;
import com.bxm.fossicker.activity.service.task.TaskService;
import com.bxm.fossicker.activity.service.gold.strategy.AbstractDoubleGoldStrategyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 任务翻倍奖励
 */
@Service("doubleGoldByTaskService")
public class DoubleGoldByTaskServiceImpl extends AbstractDoubleGoldStrategyService {

    @Autowired
    private TaskService taskService;

    @Override
    public Integer doubleGold(GoldDoubleParam goldDoubleParam) {
        Long relationId = Long.valueOf(goldDoubleParam.getRelationId());
        BigDecimal rewardNum = taskService.getRewardNum(relationId);

        //向账户添加金币
        addGold(rewardNum, goldDoubleParam);

        return showGoldNum(rewardNum.intValue(), goldDoubleParam.getCurVer());
    }

}
