package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.facade.ActivityWithdrawFacadeService;
import com.bxm.fossicker.activity.facade.model.ActivityWithdrawDto;
import com.bxm.fossicker.activity.facade.model.ActivityWithdrawNewDto;
import com.bxm.fossicker.activity.model.vo.ActivityWithdraw;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName ActivityWithdrawFacadeServiceImpl
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author zhaoxin
 * @Date 2019/7/24 13:23
 * @Version 1.0.0
 **/
@Service
public class ActivityWithdrawFacadeServiceImpl implements ActivityWithdrawFacadeService {

    @Autowired
    private WithdrawService withdrawService;

    @Autowired
    private ActivityProperties activityProperties;

    @Override
    public List<ActivityWithdrawDto> list(Long userId) {
        return withdrawService.listByUserId(userId).stream().map(this::convert).collect(Collectors.toList());
    }

    private ActivityWithdrawDto convert(ActivityWithdraw activityWithdraw) {
        return ActivityWithdrawDto.builder()
                .id(activityWithdraw.getId())
                .exceeTime(activityWithdraw.getExceeTime())
                .amount(activityProperties.getWithdrawType().get(activityWithdraw.getType().toString()))
                .build();
    }

    @Override
    public List<ActivityWithdrawNewDto> list(Long userId, Integer type) {
        return withdrawService.listByType(userId,type).stream().map(this::converts).collect(Collectors.toList());
    }
    private ActivityWithdrawNewDto converts(ActivityWithdraw activityWithdraw) {
        return ActivityWithdrawNewDto.builder()
                .id(activityWithdraw.getId())
                .exceeTime(activityWithdraw.getExceeTime())
                .type(activityWithdraw.getType())
                .status(activityWithdraw.getStatus())
                .userId(activityWithdraw.getUserId())
                .build();
    }
    @Override
    public void used(Long userId) {
        withdrawService.used(userId);
    }
    @Override
    public void used(Long userId,Long id,Integer type) {
        withdrawService.used(userId,id,type);
    }

}
