package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.config.TaskConfig;
import com.bxm.fossicker.activity.model.constant.TaskDistributedLockKey;
import com.bxm.fossicker.activity.service.AccountIntegrationService;
import com.bxm.fossicker.activity.service.ActivityAction;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.redis.DistributedLock;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * 新人礼包任务 操作
 */
@Log4j2
@Service("new_user_red_packet")
public class NewUserRedPacketActionImpl implements ActivityAction {

    private final AccountIntegrationService accountIntegrationService;

    private final UserInfoFacadeService userInfoFacadeService;

    private final TaskConfig taskConfig;

    private DistributedLock distributedLock;

    @Autowired
    public NewUserRedPacketActionImpl(AccountIntegrationService accountIntegrationService,
                                      TaskConfig taskConfig,
                                      UserInfoFacadeService userInfoFacadeService,
                                      DistributedLock distributedLock) {
        this.accountIntegrationService = accountIntegrationService;
        this.taskConfig = taskConfig;
        this.userInfoFacadeService = userInfoFacadeService;
        this.distributedLock = distributedLock;
    }

    @Override
    public BigDecimal reward(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("用户[{}]领取新人礼包", userId);
        }

        String requestId = Objects.toString(userId);
        String resource = StringUtils.join(TaskDistributedLockKey.NEW_USER_RED_PACKET, requestId);
        if (!distributedLock.lock(resource, requestId, 2, TimeUnit.SECONDS)) {

            log.warn("领取新人礼包请求频繁");
            return new BigDecimal(0);
        }

        UserInfoDto userInfoDto = userInfoFacadeService.getUserById(userId);

        if (Objects.isNull(userInfoDto) || Objects.isNull(userInfoDto.getClaimedPacket())
                || Objects.equals(userInfoDto.getClaimedPacket(), Boolean.TRUE)) {

            return new BigDecimal(0);
        }

        accountIntegrationService.rewardNewUserRedPacket(userId);

        // 更新是否领取新人礼包状态
        userInfoFacadeService.claimedPacket(userId);

        distributedLock.unlock(resource, requestId);
        return taskConfig.getNewUserRedPacket();
    }
}
