package com.bxm.fossicker.activity.service.impl;
import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.param.ActivitiesParam;
import com.bxm.fossicker.activity.model.param.UserIdParam;
import com.bxm.fossicker.activity.model.vo.TemporaryActivityVO;
import com.bxm.fossicker.activity.service.TemporaryActivityService;
import com.bxm.fossicker.activity.service.config.TempActivityProperties;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * Created by Gonzo on 2019-08-12.
 */
@Slf4j
@Service
public class TemporaryActivityServiceImpl implements TemporaryActivityService {

    @Autowired
    private UserInfoFacadeService userInfoFacadeService;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private DistributedLock lock;

    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private AccountFacadeService accountFacadeService;

    @Autowired
    private TempActivityProperties tempActivityProperties;


    @Override
    public TemporaryActivityVO activities(ActivitiesParam param) {
        TemporaryActivityVO temporaryActivity = TemporaryActivityVO.builder()
                .claimedPacket(Boolean.FALSE)
                .build();

        // 是否领取过新人礼包
        if (null != param.getUserId()) {
            UserInfoDto userInfoDto = userInfoFacadeService.getUserById(param.getUserId());

            if (null != userInfoDto) {
                temporaryActivity.setClaimedPacket(userInfoDto.getClaimedPacket());
            }
        }

        return temporaryActivity;
    }

    @Override
    public Message loginReward(UserIdParam param) {

        if (Objects.isNull(param)) {
            return Message.build(false).setMessage("参数错误");
        }

        if (!lock.lock(ActivityRedisKey.LOGIN_REWARD_LOCK.copy().appendKey(Objects.toString(param.getUserId())).gen()
                , sequenceCreater.nextStringId())) {
            return Message.build(false).setMessage("领取登录奖励过于频繁");
        }

        // 增加领取记录 缓存
        KeyGenerator key = ActivityRedisKey.LOGIN_REWARD.copy()
                .appendKey(DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
        String subKey = Objects.toString(param.getUserId());
        String res = redisHashMapAdapter.get(key, subKey, String.class);

        if (StringUtils.isNotBlank(res)) {
            if (log.isDebugEnabled()) {
                log.debug("用户: {} 已领取过登录奖励", param.getUserId());
            }
            return Message.build(false).setMessage("请勿重复领取");
        }

        redisHashMapAdapter.put(key, subKey, "1");
        redisHashMapAdapter.expire(key, DateUtils.getCurSeconds());

        // 增加奖励
        Message message = accountFacadeService.goldRebate(GoldRebateParam.builder()
                .userId(param.getUserId())
                .userGoldFlowType(UserGoldFlowTypeEnum.LOGIN_REWARD)
                .relationId(null)
                .amount(tempActivityProperties.getLoginReward())
                .build());

        if (!message.isSuccess()) {
            log.warn("领取登录奖励，账户添加金额失败，失败信息: {}", message.getLastMessage());
        }

        return Message.build();
    }

    @Override
    public LoginRewardFacadeDTO loginRewardInfo(Long userId) {

        if (Objects.nonNull(userId)) {
            KeyGenerator key = ActivityRedisKey.LOGIN_REWARD.copy()
                    .appendKey(DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
            String res = redisHashMapAdapter.get(key, Objects.toString(userId), String.class);

            LoginRewardFacadeDTO facadeDTO = new LoginRewardFacadeDTO();
            facadeDTO.setReward(tempActivityProperties.getLoginReward());
            facadeDTO.setGot(StringUtils.isNotBlank(res));

            return facadeDTO;
        }

        return null;
    }


}
