package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.fossicker.activity.model.vo.OpenTreasureBoxDTO;
import com.bxm.fossicker.activity.model.vo.TreasureBoxVO;
import com.bxm.fossicker.activity.service.TreasureBoxActivityService;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.GoldRebateParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * @auther Gonzo
 * @date 2019-09-06 14:22
 */
@Service
public class TreasureBoxActivityServiceImpl implements TreasureBoxActivityService {

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private AccountFacadeService accountFacadeService;

    @Autowired
    private ActivityProperties activityProperties;



    @Override
    public TreasureBoxVO treasureBox(Long userId) {

        Date nextOpenTime = redisHashMapAdapter.get(ActivityRedisKey.TREASURE_BOX_CACHE.copy(), userId.toString(), Date.class);

        if (Objects.isNull(nextOpenTime)) {
            return TreasureBoxVO
                    .builder()
                    .nextOpenTime(new Date())
                    .status(1)
                    .build();
        }

        return TreasureBoxVO
                .builder()
                .nextOpenTime(nextOpenTime)
                // 当前时间是否已经是下次开启之后
                .status(nextOpenTime.before(new Date()) ? 1: 0)
                .build();
    }

    @Override
    public OpenTreasureBoxDTO openTreasureBox(Long userId) {
        OpenTreasureBoxDTO openTreasureBoxResultDTO = new OpenTreasureBoxDTO();

        // 校验宝箱是否可以开启
        Date openTime = redisHashMapAdapter.get(ActivityRedisKey.TREASURE_BOX_CACHE.copy(), userId.toString(), Date.class);

        Date now = new Date();
        if (!Objects.isNull(openTime) && openTime.after(now)) {
            openTreasureBoxResultDTO.setOpenStatus(0);
            return openTreasureBoxResultDTO;
        }

        // 添加开启记录

        // 更新下一次开启时间
        Date nextOpenTime = DateUtils.addField(now, Calendar.HOUR, 4);
        redisHashMapAdapter.put(ActivityRedisKey.TREASURE_BOX_CACHE.copy(), userId.toString(), nextOpenTime);

        String awardGoldNum = activityProperties.getBoxAwardGold();
        // 添加金币
        accountFacadeService.goldRebate(GoldRebateParam
                .builder()
                .amount(new BigDecimal(awardGoldNum))
                .relationId(null)
                .userGoldFlowType(UserGoldFlowTypeEnum.TREASURE_BOX)
                .userId(userId)
                .build());

        openTreasureBoxResultDTO.setOpenStatus(1);
        openTreasureBoxResultDTO.setBoxStatus(0);
        openTreasureBoxResultDTO.setNextOpenTime(nextOpenTime);
        openTreasureBoxResultDTO.setRewardNum(awardGoldNum);
        return openTreasureBoxResultDTO;
    }

}
