package com.bxm.fossicker.activity.service.impl;

import com.bxm.fossicker.activity.domain.ActivityWithdrawMapper;
import com.bxm.fossicker.activity.service.sign.ActivitySignService;
import com.bxm.fossicker.enums.WithdrawTypeEnum;
import com.bxm.fossicker.activity.model.vo.ActivityWithdraw;
import com.bxm.fossicker.activity.service.WithdrawService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName WithdrawService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author zhaoxin
 * @Date 2019/7/24 11:38
 * @Version 1.0.0
 **/
@Log4j2
@Service
public class WithdrawServiceImpl implements WithdrawService {

    @Autowired
    private ActivityWithdrawMapper withdrawMapper;

    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private ActivitySignService activitySignService;

    @Override
    public List<ActivityWithdraw> listByUserId(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("根据用户id获取未过期可用活动提现,userId:[{}]", userId);
        }
        List<ActivityWithdraw> withdraws = withdrawMapper.selectByUserId(userId);
        return withdraws.stream().filter(p -> p.getStatus().intValue() == 0).collect(Collectors.toList());
    }

    @Override
    public List<ActivityWithdraw> listByType(Long userId ,Integer type){
        if (log.isDebugEnabled()) {
            log.debug("1.4.1 版本 根据用户id获取未过期可用活动提现,userId:[{}]", userId);
        }
        return withdrawMapper.selectByType(userId,type);
    }

    @Override
    @Async
    public void add(Long userId, WithdrawTypeEnum withdrawTypeEnum) {
        if (log.isDebugEnabled()) {
            log.debug("添加活动提现,userId:[{}],type:[{}]", userId, withdrawTypeEnum.ordinal());
        }

        //1.4.0版本去除提现机会有效期
        withdrawMapper.insertSelective(
                ActivityWithdraw.builder()
                        .id(sequenceCreater.nextLongId())
                        .userId(userId)
                        .type((byte) withdrawTypeEnum.ordinal())
                        .build()
        );
    }
    @Override
    @Async
    public void add(Long userId, Integer type) {
        if (log.isDebugEnabled()) {
            log.debug("添加活动提现,userId:[{}],type:[{}]", userId, type);
        }
        //1.4.1 版本新增提现类型 （向下兼容）
        withdrawMapper.insertSelective(
                ActivityWithdraw.builder()
                        .id(sequenceCreater.nextLongId())
                        .userId(userId)
                        .type((byte)type.intValue())
                        .build()
        );

    }
    @Override
    public void used(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("使用掉活动提现机会，更新状态,userId:[{}]", userId);
        }
        //改为根据userId 清除机会
        withdrawMapper.updateByUserId(userId);

        //使用掉活动提现机会
        activitySignService.usedChance(userId);
    }

    @Override
    public void used(Long userId, Long id, Integer type) {
        if (log.isDebugEnabled()) {
            log.debug("使用掉活动提现机会，更新状态,userId:[{}]，id:{},type : {}", userId,id,type);
        }
        // 根据类型清除
        withdrawMapper.updateStatusByUserIdAndType(userId,id,type);
    }
}
