package com.bxm.fossicker.activity.service.invite;

import com.bxm.fossicker.activity.model.dto.InviteListDto;
import com.bxm.fossicker.activity.model.dto.InviteResultDTO;
import com.bxm.fossicker.activity.model.param.BindInviteListParam;
import com.bxm.fossicker.activity.model.param.BindInviteParam;
import com.bxm.fossicker.activity.model.param.RemindParam;
import com.bxm.fossicker.user.facade.dto.InviteInfoDTO;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * @ClassName InviteService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/6/25 15:55
 * @Version 1.0.0
 **/
public interface InviteService {

    /**
     * 根据用户id获取邀请码
     *
     * @param userId 用户id
     * @return 邀请码
     */
    String getInviteCodeByUserId(Long userId);

    /**
     * 根据用户id获取邀请信息
     * @param userId
     * @return
     */
    InviteInfoDTO getInviteInfoByUserId(Long userId);

    /**
     * 输入邀请码
     *
     * @param bindInviteParam 输入的邀请码实体
     * @return 绑定成功或失败
     */
    Boolean bindRelation(BindInviteParam bindInviteParam);


    /**
     * 获取我的好友页面信息
     *
     * @param userId 用户id
     * @return 我的好友页面信息
     */
    InviteListDto getInvitedList(Long userId);

    /**
     * 提醒好友
     * 查看好友提醒状态是否已提醒，未提醒则调用短信接口，为好友的手机号码发送消息 提醒浏览商品，修改提醒状态为已提醒
     *
     * @param remindParam 提醒实体
     * @return 提醒状态 true 成功，false失败
     */
    Boolean remind(RemindParam remindParam);

    /**
     * 邀请好友接口
     * <p>
     * 新建用户
     * 新建邀请关系，状态为成功
     *
     * @param bindInviteListParam 邀请实体
     * @return 邀请状态
     */
    Message invite(BindInviteListParam bindInviteListParam);

    /**
     * 获取邀请界面滚动消息
     *
     * @return 滚动消息列表
     */
    List<String> scrollBar();

    /**
     * 校验邀请码
     * @param bindInviteParam
     * @return
     */
    InviteResultDTO checkInviteCode(BindInviteParam bindInviteParam);

    /**
     * 1.4.1.1临时方法，为了给已经绑定微信和淘宝的用户，绑定邀请码之后未发送奖励的人，再次出发奖励发送
     * @param userIds
     * @return
     */
    Message rewardRemedy(String userIds);
}
