package com.bxm.fossicker.activity.service.sign;

public interface ActivitySignService {

    /**
     * 活动签到- redis中签到天数自增
     * @param userId 用户id
     * @return
     */
    Boolean doSign(Long userId);

    /**
     * 使用活动签到机会-删除redis key-即清空活动签到天数
     * @param userId 用户id
     * @return
     */
    boolean usedChance(Long userId);

    /**
     * 获取活动签到的连续签到天数
     * @param userId 用户id
     * @return 连续签到的天数
     */
    Integer getSignedDay(Long userId);


}
