package com.bxm.fossicker.activity.service.task;

import com.bxm.fossicker.activity.model.dto.DayGoldDto;
import com.bxm.fossicker.activity.model.dto.DayGoldRedPacketDto;
import com.bxm.fossicker.activity.model.dto.TaskListDto;
import com.bxm.fossicker.activity.model.vo.NoivceRedPacketVO;
import com.bxm.fossicker.activity.model.vo.WatchVideoInfoVO;
import com.bxm.fossicker.vo.BasicParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 任务service
 *
 * @author xin.zhao
 **/
public interface TaskService {

    /**
     * 任务列表查询接口
     * <p>
     * 根据用户id和任务类型 获取该用户的任务列表，获取结果为可显示的任务
     *
     * @param userId 用户id
     * @return 任务列表
     */
    List<TaskListDto> list(Long userId, BasicParam basicParam);

    /**
     * 完成新人任务领取奖励的操作
     * <p>
     * 用户任务条件判断：
     * 1.查询用户任务状态是否为1，1表示已完成未领取
     * 2.任务剩余可完成次数为-1或者大于0 ，-1表示无限制
     * <p>
     * 满足以上条件将任务状态置为已领取。
     * 任务剩余可完成次数不为-1则减少一次任务剩余可完成数量
     *
     * @return 领取成功
     */
    Integer obtain(Long userId, Long taskId);

    /**
     * 首页任务状态查询
     * <p>
     * 首页任务包含搜索淘宝标题和观看省钱视频
     * 当该用户这两个任务的状态都为已完成，返回true
     *
     * @param userId 用户id
     * @return 任务状态
     */
    Boolean indexTaskStatus(Long userId);


    /**
     * 隐藏用户当日已经完成的新手任务，用于0点定时任务调用
     */
    void hideRewardNewUserTask();


    /**
     * 重置日常任务状态
     */
    void resetEverydayTask();


    /**
     * 查询用户的天天领现金活动信息
     *
     * @param userId 用户id
     * @return 天天领现金活动信息
     */
    DayGoldDto dayGoldInfo(Long userId);


    /**
     * 领取当日天天领现金活动的红包
     *
     * @param userId 用户id
     * @return 单个红包实体
     */
    DayGoldRedPacketDto obtainDayGold(Long userId);

    /**
     * 任务完成调用
     *
     * @param userId   任务id
     * @param taskCode 任务编码
     */
    Boolean taskComplete(Long userId, String taskCode);

    /**
     * 日常任务完成调用
     *
     * @param userId 任务id
     * @param taskId 任务id
     */
    Boolean dailyTaskComplete(Long userId, Long taskId);

    /**
     * 获取任务奖励金币数
     *
     * @param taskId 任务id
     * @return 任务奖励金币数
     */
    BigDecimal getRewardNum(Long taskId);

    /**
     * 领取当日天天领现金活动的红包
     *
     * @param userId 用户id
     * @return 单个红包实体
     */
    BigDecimal getDayGoldRewardToday(Long userId);


    /**
     * 查看用户的观看视频状态
     *
     * @param userId 用户id
     */
    WatchVideoInfoVO watchVideoInfo(Long userId);

    /**
     * 更改每日领金币 金币数
     */
    void updateDayGold();

    /**
     * 领取新人红包
     *
     * @return 奖励金额
     */
    NoivceRedPacketVO obtainNewUserRedPacket(Long userId);

    /**
     * 领取每日福利额外奖励
     *
     * @param userId
     */
    Integer receiveDailyWelfare(Long userId);

    /**
     * 激励视频观看上报
     *
     * @param userId
     */
    Integer videoReport(Long userId);
}
