package com.bxm.fossicker.activity.service.task.action;

import com.bxm.fossicker.enums.TaskEnum;

/**
 * 活动_任务接口
 *
 * @author xin.zhao
 */
public interface ActivityTaskAction {

    /**
     * 完成任务
     *
     * @param userId   用户id
     * @param taskCode 任务code 详见TaskEnum
     * @see TaskEnum
     */
    void complete(Long userId, String taskCode);

    /**
     * 领取任务奖励,仅修改任务状态为已领取
     *
     * @param userId   用户id
     * @param taskCode 任务code 详见TaskEnum
     * @return 领取奖励是否成功
     * @see TaskEnum
     */
    Boolean allowReward(Long userId, String taskCode);
}
