package com.bxm.fossicker.activity.service.task.action.impl;

import com.bxm.fossicker.activity.model.constant.ActivityRedisKey;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * 日常任务_看视频3次
 *
 * @author xin.zhao
 */
@Service("daily_task_watch_video")
@Log4j2
public class WatchVideoActionImpl extends AbstractActivityDailyTaskAction {

    @Override
    protected boolean extraCheckForComplete(Long userId) {
        KeyGenerator key = ActivityRedisKey.WATCH_VIDEO.copy().appendKey(DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
        Integer times = redisHashMapAdapter.get(key, userId.toString(), Integer.class);

        boolean flag = false;
        if (!Objects.isNull(times) && ++times == 3) {
            log.info("用户[{}]完成三次看视频任务，更新状态", userId);
            flag = true;
            redisHashMapAdapter.expire(key,86400L); // 一天过期
        }

        redisHashMapAdapter.increment(key, userId.toString(), 1);
        return flag;
    }
}
