package com.bxm.fossicker.activity.service.timer;

import com.bxm.fossicker.activity.facade.ActivitySignFacadeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 15:04
 */
@Component
@Log4j2
public class ActivitySignTask extends AbstractCronTask<String> {
    @Autowired
    private ActivitySignFacadeService activitySignFacadeService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行【活动签到确认是否断签】开始");
        try {
            activitySignFacadeService.checkInfo();

        } catch(Exception e) {
            log.error("执行【活动签到确认是否断签】失败", e);
        }

        log.info("执行【活动签到确认是否断签】结束");

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "活动签到确认是否断签";
    }

    @Override
    public String cron() {
        return "0 0 0 * * ?";
    }
}
