/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.domain.AppVersionMapper;
import com.bxm.fossicker.base.entity.AppChannelVersion;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;
import com.bxm.fossicker.base.service.AppVersionService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AppVersionServiceImpl
implements AppVersionService {
    @Resource
    private AppVersionMapper appVersionMapper;

    @Override
    public AppChannelVersionVO getVersion(AppVersionParam param) {
        AppChannelVersion version;
        List appChannelVersions = this.appVersionMapper.listEnableAppVersionInfo(param.getPlatform());
        Optional<AppChannelVersion> optionalAppChannelVersion = appChannelVersions.stream().filter(p -> StringUtils.compareVersion((String)param.getCurVer(), (String)p.getVersion()) < 0).sorted((p1, p2) -> StringUtils.compareVersion((String)p2.getVersion(), (String)p1.getVersion())).findFirst();
        if (optionalAppChannelVersion.isPresent() && Objects.nonNull((version = optionalAppChannelVersion.get()).getIsForce()) && version.getIsForce().intValue() == 1 && StringUtils.compareVersion((String)param.getCurVer(), (String)version.getForceVersion()) > 0) {
            version.setIsForce(Byte.valueOf((byte)0));
        }
        return optionalAppChannelVersion.map(this::convert).orElse(null);
    }

    @Override
    public Boolean getAuditStatus(AppVersionParam param) {
        AppChannelVersion appChannelVersion = this.appVersionMapper.getEnableAppVersionByMobileTypeAndVersion(param.getPlatform(), param.getCurVer());
        if (appChannelVersion != null) {
            return appChannelVersion.getStatus().intValue() == 1;
        }
        return Boolean.FALSE;
    }

    @Override
    public AppChannelVersion getNewversionInfo(int mobileType, String chnl) {
        return this.appVersionMapper.getNewversionInfo(mobileType, chnl);
    }

    private AppChannelVersionVO convert(AppChannelVersion appChannelVersion) {
        AppChannelVersionVO appChannelVersionVO = AppChannelVersionVO.builder().build();
        BeanUtils.copyProperties((Object)appChannelVersion, (Object)appChannelVersionVO);
        return appChannelVersionVO;
    }
}

