/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpWindowsProcess;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class PopUpWindowsInterceptorChain
implements PopUpWindowsInterceptor {
    private static final List<PopUpWindowsInterceptor> INTERCEPTORS = Lists.newArrayList();

    @Override
    public void invoke(FilterPopUpWindowsBO popUpWindows) {
        for (PopUpWindowsInterceptor interceptor : INTERCEPTORS) {
            interceptor.invoke(popUpWindows);
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onApplicationStartedEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Collection filters = applicationContext.getBeansOfType(PopUpWindowsInterceptor.class).values();
        filters.forEach(p -> {
            PopUpProcess popUpProcess = (PopUpProcess)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p), PopUpProcess.class);
            if (Objects.nonNull(popUpProcess)) {
                INTERCEPTORS.add((PopUpWindowsInterceptor)p);
                if (p instanceof PopUpWindowsProcess) {
                    ((PopUpWindowsProcess)((Object)p)).setProcessSupportPopUp(popUpProcess.special());
                }
            }
        });
        INTERCEPTORS.sort((p1, p2) -> {
            PopUpProcess popUpProcess1 = (PopUpProcess)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p1), PopUpProcess.class);
            PopUpProcess popUpProcess2 = (PopUpProcess)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p2), PopUpProcess.class);
            return Integer.compare(popUpProcess1.order().getOrder(), popUpProcess2.order().getOrder());
        });
    }
}

