/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.interceptor.Exclusion;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@PopUpProcess(order=PopUpProcessOrderEn.EXCLUSION)
public class ExclusionPopUpWindowsInterceptor
extends AbstractPopUpWindowsInterceptor {
    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        List removeList = popUpWindows.getPopUpWindows().stream().filter(p -> {
            if (StringUtils.isBlank((CharSequence)p.getExclusionJson())) {
                return false;
            }
            Exclusion exclusion = (Exclusion)JSON.parseObject((String)p.getExclusionJson(), Exclusion.class);
            if (Objects.isNull(exclusion) || Objects.isNull(exclusion.getType())) {
                return false;
            }
            switch (exclusion.getType()) {
                case 1: {
                    if (CollectionUtils.isEmpty(exclusion.getExclusionPopUpTypes())) {
                        return false;
                    }
                    return popUpWindows.getPopUpWindows().stream().filter(p1 -> exclusion.getExclusionPopUpTypes().stream().filter(p2 -> Objects.equals(p1.getType().intValue(), (int)p2)).count() > 0L).count() > 0L;
                }
                case 2: {
                    if (CollectionUtils.isEmpty(exclusion.getExclusionPopUpIds())) {
                        return false;
                    }
                    return popUpWindows.getPopUpWindows().stream().filter(p1 -> exclusion.getExclusionPopUpIds().stream().filter(p2 -> Objects.equals((long)p1.getId(), (long)p2)).count() > 0L).count() > 0L;
                }
                case 3: {
                    if (CollectionUtils.isEmpty(exclusion.getExclusionCategories())) {
                        return false;
                    }
                    return popUpWindows.getPopUpWindows().stream().filter(p1 -> exclusion.getExclusionCategories().stream().filter(p2 -> Objects.equals(p1.getCategory().intValue(), (int)p2)).count() > 0L).count() > 0L;
                }
            }
            return false;
        }).peek(p -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u4e92\u65a5\u8fc7\u6ee4\u5668, \u8fc7\u6ee4\u5f39\u7a97: {}", (Object)p.getName());
            }
        }).collect(Collectors.toList());
        popUpWindows.getPopUpWindows().removeAll(removeList);
    }
}

